class PurplePhotonBlast extends PhotonBlast;

#exec TEXTURE IMPORT NAME="PurplePhotonPattern" FILE="C:\DeusEx\MSPurple\textures\PurplePhotonPattern.pcx" GROUP=Skins

var name damageType;			// type of damage that this projectile does
var float	mpBlastRadius;
var() bool           bDamaged;         // was this blown up via damage?
var int NumWallHits;
var bool bCanHitInstigator, bHitWater;

//cant we explode even though we're bouncing? no, not really, but fuck it, we'll make it seem that way anyways.
simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ExplosionLight light;
	local int i;
	local Rotator rot;
	local PFCEffect sphere;
   local ExplosionSmall expeffect;

	// draw a pretty explosion
	light = Spawn(None,,, HitLocation);
	if (light != None)
	{
      if (!bDamaged)
         light.RemoteRole = ROLE_None;
		light.size = 8;
		light.LightHue = 128;
		light.LightSaturation = 96;
		light.LightEffect = LE_Shell;
	}

	expeffect = Spawn(None,,, HitLocation);
   if ((expeffect != None) && (!bDamaged))
      expeffect.RemoteRole = ROLE_None;

	// draw a cool light sphere
	sphere = Spawn(class'MSPurple.PFCEffect',,, HitLocation);
	if (sphere != None)
   {
      if (!bDamaged)
         sphere.RemoteRole = ROLE_None;
		sphere.size = blastRadius / 32.0;
   }
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		bIgnoresNanoDefense=True;
	}
}

//Ive had problems with falling in the past, so I keep this here
function Tick(float DeltaTime)
{
}

//a bunch of shit copied from TNAG.blade, but ive made quite a few modifications...
auto simulated state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
          
		if ( bCanHitInstigator || (Other != Instigator) && (Other != Owner) && (PurplePhotonBlast(Other) == None)) 
		{
			if ( Role == ROLE_Authority )
			{
                            //dig into these guys
                            if ((Other.IsA('Pawn')) && (!Other.IsA('Robot')))
                            {
				Other.TakeDamage(damage, instigator,HitLocation,(MomentumTransfer * Normal(Velocity)), DamageType );
                                DrawExplosionEffects(HitLocation, HitLocation); //throw a laser light party to celebrate hitting someone XD
				PlaySound(ImpactSound, SLOT_Misc, 2.0);
			        destroy();
                            }
                            //we'll just assume decos are hard surfaces, and therfore we'll bounce off of them, with a few exceptions...
                            if ((Other.IsA('DeusExDecoration')) && (!Other.IsA('HangingChicken')) && (!Other.IsA('BoxSmall')) && (!Other.IsA('Flowers')) && (!Other.IsA('BoxMedium')) && (!Other.IsA('BoxLarge')) && (!Other.IsA('HKHangingPig')))
                            {
                                Velocity -= 2 * (Velocity dot HitLocation) * HitLocation;  
		                SetRoll(Velocity);
                            }
                            //robots are obviosuly hard surfaces, so we'll bounce, dammit!
                            if (Other.IsA('Robot'))
                            {
                                Velocity -= 2 * (Velocity dot HitLocation) * HitLocation;  
		                SetRoll(Velocity);
                            }
                            //the exceptions to decoration assumption
                            if ((Other.IsA('HangingChicken')) || (Other.IsA('HKHangingPig')) || (Other.IsA('Flowers')) || (Other.IsA('BoxLarge')) || (Other.IsA('BoxMedium')) || (Other.IsA('BoxSmall')))
                            {
                                Other.TakeDamage(damage, instigator,HitLocation,(MomentumTransfer * Normal(Velocity)), DamageType );
                                DrawExplosionEffects(HitLocation, HitLocation); //BOOM!
				PlaySound(ImpactSound, SLOT_Misc, 2.0);
			        destroy();
                            }
			}
			if (Role == ROLE_Authority)
			{
            if (damagee.IsA('Pawn') && !damagee.IsA('Robot') && bBlood)
               SpawnBlood(HitLocation, Normal(HitLocation-damagee.Location));
			}
		}
	}
	simulated function ZoneChange( Zoneinfo NewZone )
	{
		local WaterRing w;
                local Pawn P;		

		if (!NewZone.bWaterZone) Return;

                ForEach AllActors(class'Pawn',P) //added this for an electricution like effect...
                { 
                 if ((P != None) && (P.Region.Zone == NewZone))
                 {
                  if (P.IsA('Robot')) //if its a robot, fry its circuits
                  {
		   P.TakeDamage(damage * 4, instigator,P.Location, vect(0,0,0), 'EMP');
                  }
                  else if (!P.IsA('Robot')) //otherwards, electrocute it to death
                  {
		   P.TakeDamage(damage * 2, instigator,P.Location, vect(0,0,0), 'Shocked');
                  }
                 }
                }
                Destroy();
	}

	simulated function SetRoll(vector NewVelocity) 
	{
		local rotator newRot;	
	
		newRot = rotator(NewVelocity);	
		SetRotation(newRot); //DO A BARREL ROLL!!!	
	}

	simulated function HitWall (vector HitNormal, actor Wall)
	{
		local vector Vel2D, Norm2D;

		bCanHitInstigator = true;
		PlaySound(ImpactSound, SLOT_Misc, 2.0);;
		if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
		{
			if ( Role == ROLE_Authority )
				Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), 'shot');
			return;
		}
		SetTimer(0, False);
		MakeNoise(0.3);
		NumWallHits++;
		if ( NumWallHits == 1 ) 
		{
			Spawn(class'RockChip',,,Location, rotator(HitNormal));
			Vel2D = Velocity;
			Vel2D.Z = 0;
			Norm2D = HitNormal;
			Norm2D.Z = 0;
			Norm2D = Normal(Norm2D);
			Vel2D = Normal(Vel2D);
			if ( (Vel2D Dot Norm2D) < -0.999 )
			{
				HitNormal = Normal(HitNormal + 0.6 * Vel2D);
				Norm2D = HitNormal;
				Norm2D.Z = 0;
				Norm2D = Normal(Norm2D);
				if ( (Vel2D Dot Norm2D) < -0.999 )
				{
					if ( Rand(1) == 0 )
						HitNormal = HitNormal + vect(0.05,0,0);
					else
						HitNormal = HitNormal - vect(0.05,0,0);
					if ( Rand(1) == 0 )
						HitNormal = HitNormal + vect(0,0.05,0);
					else
						HitNormal = HitNormal - vect(0,0.05,0);
					HitNormal = Normal(HitNormal);
				}
			}
		}
		Velocity -= 2 * (Velocity dot HitNormal) * HitNormal;  //WHEEEE!!!
		SetRoll(Velocity);
	}

	function SetUp()
	{
		local vector X;

		X = vector(Rotation);	
		Velocity = Speed * X;     // Impart ONLY forward vel
		if (Instigator.HeadRegion.Zone.bWaterZone)
			bHitWater = True;	
	}

	simulated function BeginState()
	{

		SetTimer(0.2, false);
		SetUp();

		if ( Level.NetMode != NM_DedicatedServer )
		{
			if ( Level.NetMode == NM_Standalone )
				SoundPitch = 200 + 50 * FRand();
		}			
	}

	simulated function Timer()
	{
		bCanHitInstigator = true;
	}
}


defaultproperties
{
     DamageType=Disintegrated
     mpBlastRadius=77.700000
     bExplodes=False
     blastRadius=48.000000
     ItemName="Purple Photon Blast"
     Damage=7.770000
     ImpactSound=None
     RotationRate=(Pitch=0,Yaw=0, Roll=32192)
     ExplosionDecal=None
     Skin=Texture'MSPurple.Skins.PurplePhotonPattern'
     LifeSpan=15
     DrawScale=0.777000
     SoundRadius=128
     SoundVolume=50
     LightHue=205
     LightSaturation=50
     LightBrightness=14
     LightRadius=16
     bBounce=True
}
